package gov.va.med.mhv.usermgmt.data.repository;


import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.UserProfile;


@Repository
public interface UserProfileRepository extends JpaRepository<UserProfile, Long>{

	/**
	 *
	 * @param userName
	 * @return
	 */
	@Query("select u from UserProfile u where lower(u.userName) = lower(:userName)")
	UserProfile findByUserName(@Param("userName") String userName);


	/**
	 *
	 * @param userName
	 * @return
	 */
	@Query("select u from UserProfile u where u.id = :id")
	UserProfile getUserProfileById(@Param("id") Long id);


	/**
	 *
	 * @param userName
	 * @return
	 */
	@Query("Select u from UserProfile u where u.userName like :userName")
	List <UserProfile>findByUserNameLike(@Param("userName") String userName);


	/**
	 * Execute the GetProfileByNameBirthDateSsnExcludeId query
	 *
	 * @param firstName The firstName
	 * @param lastName The lastName
	 * @param birthDate The birthDate
	 * @param ssn The ssn
	 * @param id The id
	 * @return List of UserProfiles
	 */
	@Query("Select u from UserProfile u where u.firstName = :firstName and u.lastName = :lastName and u.birthDate= :birthDate and u.ssn=:ssn and u.id=:id")
	List <UserProfile>getProfileByNameBirthDateSsnExcludeId(@Param("firstName") String firstName,@Param("lastName") String lastName,@Param("birthDate") Date birthDate,
			@Param("ssn") String ssn,@Param("id") Long id);

	/**
	 *
	 * @param firstName
	 * @param lastName
	 * @param birthDate
	 * @param ssn
	 * @return
	 */
	@Query("Select u from UserProfile u where ((:firstName is null and u.firstName is null) or (:firstName = '%' and u.firstName is null) or (:firstName is not null "+
		   "and lower(u.firstName) = :firstName)) and lower(u.lastName) like :lastName and u.birthDate = :birthDate and ((:ssn is null and u.ssn is null) "+
		   "or (:ssn = '%' and u.ssn is null) or (:ssn is not null and u.ssn like :ssn ))")
	List<UserProfile> getProfileByNameBirthDateSsnIncludedDeleted(@Param("firstName") String firstName,@Param("lastName") String lastName,@Param("birthDate") Date birthDate,
			@Param("ssn") String ssn);

	/**
	 * Execute the GetProfileByNameBirthDateSsn query
	 *
	 * @param firstName The firstName
	 * @param lastName The lastName
	 * @param birthDate The birthDate
	 * @param ssn The ssn
	 * @return List of UserProfiles
	 */
	@Query("Select u from UserProfile u where lower(u.firstName) =lower(:firstName) and lower(u.lastName)  = lower(:lastName) and u.birthDate= :birthDate and u.ssn=:ssn")
	List <UserProfile>getProfileByNameBirthDateSsn(@Param("firstName") String firstName,@Param("lastName") String lastName,@Param("birthDate") Date birthDate,
			@Param("ssn") String ssn);

	/**
	 * Execute the GetProfileByNameBirthDate query
	 *
	 * @param firstName The firstName
	 * @param lastName The lastName
	 * @param gender The gender
	 * @param birthDate The birthDate
	 * @return List of UserProfiles
	 */
	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and u.gender= :gender and u.birthDate= :birthDate" )
	List <UserProfile>getProfileByNameBirthDate(@Param("firstName") String firstName, @Param("lastName") String lastName, @Param("gender") String gender, @Param("birthDate") Date birthDate);
	

	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and u.gender= :gender and u.gender= :gender")
	List <UserProfile>getProfileByNameBirthDateForVAAFI(@Param("firstName") String firstName, @Param("lastName") String lastName, @Param("gender") String gender);

	@Query("Select u from UserProfile u where lower(u.firstName) = lower(:firstName) and lower(u.lastName) = lower(:lastName) and lower(u.userName) = lower(:userName) and u.gender= :gender and u.birthDate = :birthDate")
	List <UserProfile>getProfileByNameUserNameBirthDate(@Param("firstName") String firstName, @Param("lastName") String lastName,@Param("userName") String userName, @Param("gender") String gender, @Param("birthDate") Date birthDate);
	
	@Query("Select u from UserProfile u where u.birthDate= :birthDate and u.ssn=:ssn and lower(u.firstName) = lower(:firstName) "
			+ "and lower(u.lastName) = lower(:lastName) and u.deactivationReason is null")
	List <UserProfile>getActiveProfileByBirthDateSSN(@Param("birthDate") Date birthDate, @Param("ssn") String ssn, 
			@Param("firstName") String firstName, @Param("lastName") String lastName);
	
}